@extends('laravelinstaller::layouts.master')

@section('template_title')
    {{ __('Step 4 | Environment Settings') }}
@endsection

@section('title')
    <i class="fa fa-database fa-fw" aria-hidden="true"></i>
    {{ __('Setup Database') }}
@endsection

@section('container')
    <form method="post" action="{{ route('LaravelInstaller::environmentSave') }}">
        <input type="hidden" name="_token" value="{{ csrf_token() }}">
        <div class="form-group {{ $errors->has('database_hostname') ? ' has-error ' : '' }}">
            <label for="database_hostname">
                {{ __('Database Host') }}
            </label>
            <input type="text" name="database_hostname" id="database_hostname" value="localhost"
                placeholder="{{ __('Database Host') }}" required>
            @if ($errors->has('database_hostname'))
                <span class="error-block">
                    <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                    {{ $errors->first('database_hostname') }}
                </span>
            @endif
        </div>

        <div class="form-group {{ $errors->has('database_port') ? ' has-error ' : '' }}">
            <label for="database_port">
                {{ __('Database Port') }}
            </label>
            <input type="number" name="database_port" id="database_port" value="3306"
                placeholder="{{ __('Database Port') }}" required>
            @if ($errors->has('database_port'))
                <span class="error-block">
                    <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                    {{ $errors->first('database_port') }}
                </span>
            @endif
        </div>

        <div class="form-group {{ $errors->has('database_name') ? ' has-error ' : '' }}">
            <label for="database_name">
                {{ __('Database Name') }}
            </label>
            <input type="text" name="database_name" id="database_name" value=""
                placeholder="{{ __('Database Name') }}" required>
            @if ($errors->has('database_name'))
                <span class="error-block">
                    <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                    {{ $errors->first('database_name') }}
                </span>
            @endif
        </div>

        <div class="form-group {{ $errors->has('database_username') ? ' has-error ' : '' }}">
            <label for="database_username">
                {{ __('Database User Name') }}
            </label>
            <input type="text" name="database_username" id="database_username" value=""
                placeholder="{{ __('Database User Name') }}" required>
            @if ($errors->has('database_username'))
                <span class="error-block">
                    <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                    {{ $errors->first('database_username') }}
                </span>
            @endif
        </div>

        <div class="form-group {{ $errors->has('database_password') ? ' has-error ' : '' }}">
            <label for="database_password">
                {{ __('Database Password') }}
            </label>
            <input type="password" name="database_password" id="database_password" value=""
                placeholder="{{ __('Database Password') }}" />
            @if ($errors->has('database_password'))
                <span class="error-block">
                    <i class="fa fa-fw fa-exclamation-triangle" aria-hidden="true"></i>
                    {{ $errors->first('database_password') }}
                </span>
            @endif
        </div>

        <div class="buttons">
            <button class="button" type="submit">
                {{ __('Install') }}
                <i class="fa fa-angle-right fa-fw" aria-hidden="true"></i>
            </button>
        </div>
    </form>
@endsection
